package org.mulesoft.apb.client.scala.instances

import amf.core.client.scala.validation.AMFValidationReport
import amf.core.internal.remote.Mimes
import amf.shapes.client.scala.model.document.JsonLDInstanceDocument
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.client.scala.instances.APIInstanceParseResult.toAPIInstanceParseResult
import org.mulesoft.apb.internal.loaders.InMemoryResourceLoader
import org.mulesoft.apb.internal.render.APIInstanceRenderer
import org.mulesoft.apb.project.client.scala.model.BaseUnitBuildResult
import org.mulesoft.apb.project.client.scala.model.descriptor.Instance
import org.mulesoft.apb.project.client.scala.model.management.APIInstance

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

case class APIInstanceHandler(base: String = APIInstanceHandler.DEFAULT_IRI) {
  def parse(content: String): Future[APIInstanceParseResult] = {
    APIInstanceClient
      .build(Instance(base), List(InMemoryResourceLoader(base, content, Mimes.`application/yaml`)))
      .map(toAPIInstanceParseResult)
  }

  def render(instance: APIInstance): String = APIInstanceRenderer(instance).render()
}

object APIInstanceHandler {
  val DEFAULT_IRI = "http://a.ml/amf/default_document"
}

case class APIInstanceParseResult(instance: APIInstance, report: AMFValidationReport)

object APIInstanceParseResult {
  def toAPIInstanceParseResult(buildResult: BaseUnitBuildResult): APIInstanceParseResult = {
    val doc      = buildResult.result.asInstanceOf[JsonLDInstanceDocument]
    val instance = APIInstance(doc.encodes.head.asInstanceOf[JsonLDObject])
    val report   = buildResult.report
    APIInstanceParseResult(instance, report)
  }
}
