package org.mulesoft.apb.client.platform

import amf.core.client.platform.model.document.BaseUnit
import amf.core.client.platform.validation.AMFValidationReport
import amf.core.client.scala.validation
import org.mulesoft.apb.project.client.platform.model.ProjectBuildResult
import org.mulesoft.apb.client.scala.{APIProjectClient => InternalAPIProjectClient}
import org.mulesoft.apb.internal.convert.APBClientConverters._
import org.mulesoft.apb.project.client.platform.model.descriptor.Gav
import org.mulesoft.apb.project.client.platform.model.project.Project

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future
import scala.scalajs.js.annotation.JSExportAll

// TODO native-jsonld: change policies for a list of generic runtime dependencies with their own definition for merging
@JSExportAll
class APIProjectClient private[apb] (private[apb] val _internal: InternalAPIProjectClient) {

  def assemble(): ClientFuture[ProjectBuildResult] = _internal.assemble().asClient
  def serialize(): ClientFuture[String]            = _internal.serialize().asClient

  def serialize(project: Project): String = _internal.serialize(project)

  def summary(schemaBase: String): ClientFuture[String] = _internal.summary(schemaBase).asClient

  def summary(schemaBase: String, project: Project): String = _internal.summary(schemaBase, project)

  def validate(project: Project): ClientFuture[AMFValidationReport] = _internal.validate(project).asClient

  def validate(): ClientFuture[AMFValidationReport] = _internal.validate().asClient

  def lint(rulesets: ClientList[Gav]): ClientFuture[ClientList[AMFValidationReport]] = {
    _internal.lint(rulesets.asInternal.toList).asClient
  }

  def lint(rulesets: ClientList[Gav], project: Project): ClientFuture[ClientList[AMFValidationReport]] = {
    _internal.lint(rulesets.asInternal.toList, project).asClient
  }

  def lint(): ClientFuture[ClientList[AMFValidationReport]] = _internal.lint().asClient

  def lint(project: Project): ClientFuture[ClientList[AMFValidationReport]] = {
    _internal.lint(project).asClient
  }

}

trait ClientProjectNodeCache {
  def fetch(uri: String): ClientOption[ClientFuture[BaseUnit]]
}
