package org.mulesoft.apb.client.platform.contract

import amf.apicontract.client.platform.AMFConfiguration
import amf.core.client.platform.validation.AMFValidationReport
import amf.core.client.platform.{AMFParseResult, AMFResult}
import org.mulesoft.apb.client.scala.contract.{APIContractClient => InternalAPBClient}
import org.mulesoft.apb.internal.convert.APBClientConverters._
import org.mulesoft.apb.project.client.platform.ProjectConfiguration
import org.mulesoft.apb.project.client.platform.model.descriptor.Gav

import scala.concurrent.ExecutionContext.Implicits.global
import scala.scalajs.js.annotation.JSExportAll

@JSExportAll
class APIContractClient private[apb] (private[apb] val _internal: InternalAPBClient) {

  val projectConfiguration: ProjectConfiguration = _internal.projectConfiguration

  def getAMFConfiguration: AMFConfiguration = _internal.getAMFConfiguration

  def compile(): ClientFuture[AMFParseResult] = _internal.compile().asClient

  def build(): ClientFuture[AMFResult] = _internal.build().asClient

  def report(): ClientFuture[AMFValidationReport] = _internal.report().asClient

  def lint(): ClientFuture[AMFValidationReport] = _internal.lint().asClient

  def checkTree(): AMFValidationReport = _internal.checkTree()

  lazy val listDependencies: ClientList[Gav] = _internal.listDependencies.asClient
}
