package org.mulesoft.apb.client.platform.directory

import amf.core.client.platform.resource.ResourceLoader
import amf.core.client.platform.validation.AMFValidationReport
import org.mulesoft.apb.client.scala.directory.{APIProjectDirectoryCheck => InternalAPIProjectDirectoryCheck}
import org.mulesoft.apb.internal.convert.APBClientConverters._

import scala.concurrent.ExecutionContext.Implicits.global
import scala.language.implicitConversions
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
class APIProjectDirectoryCheck private[apb] (private val internal: InternalAPIProjectDirectoryCheck) {

  @JSExportTopLevel("APIProjectDirectoryCheck")
  def this(resourceLoader: ResourceLoader) = {
    this(InternalAPIProjectDirectoryCheck(ResourceLoaderMatcher.asInternal(resourceLoader)))
  }

  def check(): ClientFuture[AMFValidationReport] = internal.check().asClient
}
