package org.mulesoft.apb.client.scala

import org.mulesoft.apb.project.client.scala.{ProjectConfiguration, ProjectConfigurationBuilder}
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.extensions.APIProjectExtension
class APIProjectClientBuilder(override val dependencyFetcher: DependencyFetcher)
    extends APIBaseClientBuilder[APIProjectClient](dependencyFetcher) {

  private var cache: Option[ProjectNodeCache]      = None
  private var extensions: Seq[APIProjectExtension] = List.empty
  private var base: Option[String]                 = None

  def withCache(cache: ProjectNodeCache): APIProjectClientBuilder = {
    this.cache = Some(cache)
    this
  }

  def withExtensions(extensions: Seq[APIProjectExtension]): APIProjectClientBuilder = {
    this.extensions = extensions
    this
  }

  def withBase(base: String): APIProjectClientBuilder = {
    this.base = Some(base)
    this
  }

  override protected def build(projectConfiguration: ProjectConfiguration) =
    new APIProjectClient(projectConfiguration, dependencyFetcher, resourceLoaders, cache, extensions, base)

  override protected def getProjectConfigurationBuilder: ProjectConfigurationBuilder =
    new ProjectConfigurationBuilder(dependencyFetcher, resourceLoaders)
}
