package org.mulesoft.apb.project.internal.generated

import amf.core.internal.remote.Mimes
import org.mulesoft.apb.internal.generated.ApiInstanceSchema
import org.mulesoft.apb.internal.loaders.InMemoryResourceLoader
import org.mulesoft.apb.project.internal.gcl.SchemaProvider

object GCLSchemaDefaultRL {

  private val apiInstanceSchema = ApiInstanceSchema.schema

  private val policyBindingSchema = PolicyBindingSchema.schema

  val loaders = SchemaProvider.all.toList.map { case (kind, schema) =>
    InMemoryResourceLoader(kind, schema, Mimes.`application/json`)
  }

  def commonLoader = SchemaProvider
    .get("commons.json")
    .map(schema => InMemoryResourceLoader("commons.json", schema, Mimes.`application/json`))

  def extensionLoaders = SchemaProvider.extensions().toList.map { case (kind, schema) =>
    InMemoryResourceLoader(kind, schema, Mimes.`application/json`)
  }
}
