package org.mulesoft.apb.client.platform.instances

import amf.core.client.platform.resource.ResourceLoader
import org.mulesoft.apb.internal.client.instances.{APIInstanceClient => InternalAPIInstanceClient}
import org.mulesoft.apb.internal.convert.APBClientConverters._
import org.mulesoft.apb.project.client.platform.model.BaseUnitBuildResult
import org.mulesoft.apb.project.client.platform.model.descriptor.Instance

import scala.concurrent.ExecutionContext
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}
@JSExportAll
private[apb] class APIInstanceClient private[apb] (private[apb] val _internal: InternalAPIInstanceClient) {

  private implicit val executionContext: ExecutionContext = ExecutionContext.Implicits.global
  def build(): ClientFuture[BaseUnitBuildResult]          = _internal.build().asClient
}

@JSExportAll
//@JSExportTopLevel("APIInstanceClient")
private[apb] object APIInstanceClient {

  private implicit val executionContext: ExecutionContext = ExecutionContext.Implicits.global
  def build(instance: Instance, resourceLoaders: ClientList[ResourceLoader]): ClientFuture[BaseUnitBuildResult] =
    InternalAPIInstanceClient.build(instance, resourceLoaders.asInternal.toList).asClient
}
