package org.mulesoft.apb.client.platform.instances

import amf.core.client.platform.resource.ResourceLoader
import org.mulesoft.apb.internal.client.instances.{APIInstanceClientBuilder => InternalBuilder}
import org.mulesoft.apb.internal.convert.APBClientConverters._

import scala.concurrent.ExecutionContext
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
private[apb] class APIInstanceClientBuilder private[apb] (private val internal: InternalBuilder) {

  private implicit val executionContext: ExecutionContext = ExecutionContext.Implicits.global

//  @JSExportTopLevel("APIInstanceClientBuilder")
  def this(instance: String) {
    this(new InternalBuilder(instance))
  }

  def withResourceLoader(loader: ResourceLoader): APIInstanceClientBuilder = {
    internal.withResourceLoader(ResourceLoaderMatcher asInternal loader)
    this
  }

  def withSchemaDefinition(url: String): APIInstanceClientBuilder = {
    internal.withSchemaDefinition(url)
    this
  }

  def build(): APIInstanceClient = internal.build()
}
