package org.mulesoft.apb.client.scala

import amf.core.client.common.validation.{SeverityLevels, UnknownProfile}
import amf.core.client.scala.model.document.{BaseUnit, Document}
import amf.core.client.scala.validation.{AMFValidationReport, AMFValidationResult}
import org.mulesoft.apb.project.client.scala.ProjectConfiguration
import org.mulesoft.apb.project.client.scala.model.descriptor.Gav
import org.mulesoft.apb.project.client.scala.model.{BaseUnitBuildResult, ProjectBuildResult}

import scala.concurrent.Future

trait APIProjectClient {

  // TODO: result type has to change before 2.0, for the meantime we go this path.
  def dependencies(): Future[ProjectConfiguration]
  def project(): Future[ProjectBuildResult]
  def validate(): Future[AMFValidationReport]
  def serialize(): Future[String]
  def summary(schemaBase: String): Future[String]
  def lint(): Future[List[AMFValidationReport]]
  def lint(rulesets: List[Gav]): Future[List[AMFValidationReport]]
}

trait ProjectNodeCache {
  def fetch(uri: String): Option[Future[BaseUnit]]
}
