package org.mulesoft.apb.internal.client.contract

import org.mulesoft.apb.client.scala.APIBaseClientBuilder
import org.mulesoft.apb.project.client.scala.dependency.{APBUnitCacheBuilder, UnitCacheBuilder}
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.ProjectConfiguration
import org.mulesoft.apb.project.internal.dependency.ProjectConfigurationBuilder
import org.mulesoft.apb.project.internal.validations.ProjectValidations.MissingMainFile

case class APIContractClientBuilder(override val dependencyFetcher: DependencyFetcher)
    extends APIBaseClientBuilder[APIContractClient](dependencyFetcher) {

  private var unitsCacheBuilder: UnitCacheBuilder = APBUnitCacheBuilder

  def withCacheBuilder(builder: UnitCacheBuilder): this.type = {
    this.unitsCacheBuilder = builder
    this
  }

  override def build(configuration: ProjectConfiguration): APIContractClient = {
    configuration.descriptor.main match {
      case Some(main) => new APIContractClient(configuration, main)
      case _          => throw MissingMainFileException
    }
  }
  override protected def getProjectConfigurationBuilder: ProjectConfigurationBuilder =
    new ProjectConfigurationBuilder(dependencyFetcher, resourceLoaders, unitsCacheBuilder)
}

object MissingMainFileException extends Exception(MissingMainFile.message)
