package org.mulesoft.apb.internal.convert

import amf.core.client.scala.model.document.BaseUnit
import amf.core.internal.convert.{ClientInternalMatcher, InternalClientMatcher}
import org.mulesoft.apb.client.platform.instances.{APIInstanceClient => ClientAPIInstanceClient}
import org.mulesoft.apb.client.platform.{ClientProjectNodeCache, APIProjectClient => ClientAPIProjectClient}
import org.mulesoft.apb.client.scala.{APIProjectClient, ProjectNodeCache}
import org.mulesoft.apb.internal.client.instances.APIInstanceClient
import org.mulesoft.apb.project.client.platform.model.project.{Project => ClientProject}
import org.mulesoft.apb.project.client.scala.model.project.Project
import org.mulesoft.apb.project.internal.convert.APBProjectConverters

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future
object APBClientConverters extends APBProjectConverters {

  implicit object APBProjectConverter extends InternalClientMatcher[Project, ClientProject] {
    override def asClient(from: Project): ClientProject = new ClientProject(from)
  }

  implicit object APBAPIInstanceClientConverter
      extends InternalClientMatcher[APIInstanceClient, ClientAPIInstanceClient] {
    override def asClient(from: APIInstanceClient): ClientAPIInstanceClient = new ClientAPIInstanceClient(from)
  }

  implicit object APBProjectClientConverter extends InternalClientMatcher[APIProjectClient, ClientAPIProjectClient] {
    override def asClient(from: APIProjectClient): ClientAPIProjectClient = new ClientAPIProjectClient(from)
  }

  implicit object APBClientProjectNodeCache extends ClientInternalMatcher[ClientProjectNodeCache, ProjectNodeCache] {
    override def asInternal(from: ClientProjectNodeCache): ProjectNodeCache = new ProjectNodeCache {
      override def fetch(uri: String): Option[Future[BaseUnit]] =
        toScalaOption(from.fetch(uri)).map(client => {
          asInternalFuture(client, BaseUnitMatcher)
        })
    }
  }
}
