package org.mulesoft.apb.client.platform

import amf.core.client.platform.model.document.BaseUnit
import amf.core.client.platform.validation.AMFValidationReport
import org.mulesoft.apb.client.scala.{APIProjectClient => InternalAPIProjectClient}
import org.mulesoft.apb.internal.convert.APBClientConverters._
import org.mulesoft.apb.project.client.platform.model.ProjectBuildResult
import org.mulesoft.apb.project.client.platform.model.descriptor.Gav

import scala.concurrent.ExecutionContext.Implicits.global
import scala.scalajs.js.annotation.JSExportAll

@JSExportAll
class APIProjectClient private[apb] (private[apb] val _internal: InternalAPIProjectClient) {

  def project(): ClientFuture[ProjectBuildResult] = _internal.project().asClient

  def validate(): ClientFuture[AMFValidationReport]         = _internal.validate().asClient
  def serialize(): ClientFuture[String]                     = _internal.serialize().asClient
  def summary(schemaBase: String): ClientFuture[String]     = _internal.summary(schemaBase).asClient
  def lint(): ClientFuture[ClientList[AMFValidationReport]] = _internal.lint().asClient
  def lint(rulesets: ClientList[Gav]): ClientFuture[ClientList[AMFValidationReport]] = {
    _internal.lint(rulesets.asInternal.toList).asClient
  }
}

trait ClientProjectNodeCache {
  def fetch(uri: String): ClientOption[ClientFuture[BaseUnit]]
}
