package org.mulesoft.apb.client.scala

import amf.core.client.common.validation.ProfileName
import amf.core.client.scala.AMFGraphConfiguration
import amf.core.client.scala.resource.ResourceLoader
import amf.core.client.scala.validation.AMFValidationReport
import amf.core.internal.unsafe.PlatformSecrets
import org.mulesoft.apb.internal.cache.ProjectNodeCache
import org.mulesoft.apb.internal.client.project.DefaultAPIProjectClient
import org.mulesoft.apb.project.client.scala.dependency.{APBUnitCacheBuilder, UnitCacheBuilder}
import org.mulesoft.apb.project.client.scala.descriptor.DescriptorParseResult
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.extensions.APIProjectExtension
import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.internal.environment.{GavPathDependencyFetcher, ProjectRelativeRL}
import org.mulesoft.apb.project.internal.parser.APBEnv

import scala.concurrent.{ExecutionContext, Future}
class APIProjectClientBuilder(private val dependencyFetcher: DependencyFetcher)(implicit ctx: ExecutionContext)
    extends PlatformSecrets {

  private var cache: Option[ProjectNodeCache]         = None
  private var extensions: Seq[APIProjectExtension]    = List.empty
  private var base: Option[String]                    = None
  protected var resourceLoaders: List[ResourceLoader] = platform.loaders().toList
  private var unitCacheBuilder: UnitCacheBuilder      = APBUnitCacheBuilder

  def withResourceLoaders(loaders: List[ResourceLoader]): this.type = {
    this.resourceLoaders = loaders
    this
  }

  def withResourceLoader(loader: ResourceLoader): this.type = {
    this.resourceLoaders = loader +: this.resourceLoaders
    this
  }

  // TODO: remove
  private[apb] def withCache(cache: ProjectNodeCache): APIProjectClientBuilder = {
    this.cache = Some(cache)
    this
  }

  def withExtensions(extensions: Seq[APIProjectExtension]): APIProjectClientBuilder = {
    this.extensions = extensions
    this
  }

  // TODO: reconsider
  def withBase(base: String): APIProjectClientBuilder = {
    this.base = Some(base)
    this
  }

  def withDirectory(directory: String): APIProjectClientBuilder = {
    withResourceLoader(ProjectRelativeRL(directory)) // this is shady
  }

  def build(): Future[APIProjectClient] = {
    buildFromDirectory()
  }

  def build(descriptor: ProjectDescriptor): APIProjectClient = {
    build(DescriptorParseResult(descriptor, AMFValidationReport.empty("", ProfileName("AMF"))))
  }

  private def build(parsedDescriptor: DescriptorParseResult): APIProjectClient = {
    client(parsedDescriptor)
  }

  private[apb] def buildFromContent(descriptor: String): APIProjectClient = {
    val parsedDescriptor = parseDescriptor(descriptor)
    build(parsedDescriptor)
  }

  private def client(descriptor: DescriptorParseResult) = {
    new DefaultAPIProjectClient(
        descriptor,
        GavPathDependencyFetcher(dependencyFetcher),
        this.resourceLoaders,
        unitCacheBuilder,
        cache,
        extensions,
        base
    )
  }

  private def buildFromDirectory(): Future[APIProjectClient] = {
    val eventualContent = fetchDescriptorFile()
    eventualContent.map(c => buildFromContent(c.stream.toString))
  }

  private def fetchDescriptorFile() = fetchFile(APBEnv.descriptorFileName)

  private def fetchFile(file: String) = {
    val config = AMFGraphConfiguration.empty().withResourceLoaders(resourceLoaders)
    platform.fetchContent(file, config)
  }

  private def parseDescriptor(descriptor: String): DescriptorParseResult = APBEnv.getHandler().parse(descriptor)
}
