package org.mulesoft.apb.internal.client.contract

import org.mulesoft.apb.internal.client.APIBaseClientBuilder
import org.mulesoft.apb.project.client.scala.dependency.{APBUnitCacheBuilder, UnitCacheBuilder}
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.{DependencySet, ProjectConfiguration}
import org.mulesoft.apb.project.internal.dependency.DependencySetParser
import org.mulesoft.apb.project.internal.environment.GavPathDependencyFetcher
import org.mulesoft.apb.project.internal.validations.ProjectValidations.MissingMainFile

import scala.concurrent.ExecutionContext.Implicits.global

case class APIContractClientBuilder(override val dependencyFetcher: DependencyFetcher)
    extends APIBaseClientBuilder[APIContractClient](dependencyFetcher) {

  private var unitsCacheBuilder: UnitCacheBuilder = APBUnitCacheBuilder

  def withCacheBuilder(builder: UnitCacheBuilder): this.type = {
    this.unitsCacheBuilder = builder
    this
  }

  override def build(configuration: DependencySet): APIContractClient = {
    configuration.descriptor().main match {
      case Some(main) => new APIContractClient(configuration, resourceLoaders, unitsCacheBuilder, main)
      case _          => throw MissingMainFileException
    }
  }
  override protected def getProjectConfigurationBuilder: DependencySetParser =
    new DependencySetParser(GavPathDependencyFetcher(dependencyFetcher), resourceLoaders, unitsCacheBuilder)
}

object MissingMainFileException extends Exception(MissingMainFile.message)
