package org.mulesoft.apb.internal.client.instances

import amf.shapes.client.scala.model.document.JsonLDInstanceDocument
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.client.scala.instances.APIInstanceParseResult
import org.mulesoft.apb.project.client.scala.model.BaseUnitBuildResult
import org.mulesoft.apb.project.client.scala.model.project.management.APIInstance

object APIInstanceParseResultAdapter {
  def toAPIInstanceParseResult(buildResult: BaseUnitBuildResult): APIInstanceParseResult = {
    val doc      = buildResult.result.asInstanceOf[JsonLDInstanceDocument]
    val instance = APIInstance(doc.encodes.head.asInstanceOf[JsonLDObject])
    val report   = buildResult.report
    APIInstanceParseResult(instance, report)
  }
}
