package org.mulesoft.apb.client.platform

import amf.core.client.platform.validation.AMFValidationReport
import amf.core.internal.convert.CoreClientConverters.{
  ClientFuture,
  ClientList,
  InternalFutureOps,
  ValidationReportMatcher
}
import amf.core.internal.convert.InternalClientMatcher
import org.mulesoft.apb.client.scala.{APIProjectClient => InternalAPIProjectClient}
import org.mulesoft.apb.project.client.platform.DependencySet
import org.mulesoft.apb.project.client.platform.model.ProjectBuildResult
import org.mulesoft.apb.project.client.platform.model.descriptor.Gav
import org.mulesoft.apb.project.client.scala.{DependencySet => InternalDependencySet}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import java.util.concurrent.CompletableFuture
import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future
import scala.scalajs.js.annotation.JSExportAll

@JSExportAll
class APIProjectClient private[apb] (private[apb] val _internal: InternalAPIProjectClient) {

  def dependencies(): ClientFuture[DependencySet] = asClient(_internal.dependencies())

  def project(): ClientFuture[ProjectBuildResult] = _internal.project().asClient

  def validate(): ClientFuture[AMFValidationReport]         = _internal.validate().asClient
  def serialize(): ClientFuture[String]                     = _internal.serialize().asClient
  def summary(schemaBase: String): ClientFuture[String]     = _internal.summary(schemaBase).asClient
  def lint(): ClientFuture[ClientList[AMFValidationReport]] = _internal.lint().asClient
  def lint(rulesets: ClientList[Gav]): ClientFuture[ClientList[AMFValidationReport]] = {
    _internal.lint(rulesets.asInternal.toList).asClient
  }

  private def asClient(internal: Future[InternalDependencySet]): ClientFuture[DependencySet] = {
    implicit val matcher = new InternalClientMatcher[InternalDependencySet, DependencySet] {
      override def asClient(from: InternalDependencySet): DependencySet = DependencySetConverter.asClient(from)
    }
    internal.asClient
  }
}
