package org.mulesoft.apb.client.scala

import amf.core.client.common.remote.Content
import amf.core.client.scala.AMFGraphConfiguration
import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.unsafe.PlatformSecrets
import org.mulesoft.apb.client.scala.extensions.APIProjectExtension
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.model.ProjectDescriptor
import org.mulesoft.apb.project.internal.parser.APBEnv

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

class APIProjectClientBuilder(dependencyFetcher: DependencyFetcher) extends PlatformSecrets {

  private var loader: Option[ResourceLoader]       = None
  private var cache: Option[ProjectNodeCache]      = None
  private var extensions: Seq[APIProjectExtension] = List.empty

  def withResourceLoader(loader: ResourceLoader): APIProjectClientBuilder = {
    this.loader = Some(loader)
    this
  }

  def withCache(cache: ProjectNodeCache): APIProjectClientBuilder = {
    this.cache = Some(cache)
    this
  }

  def withExtensions(extensions: Seq[APIProjectExtension]): APIProjectClientBuilder = {
    this.extensions = extensions
    this
  }

  def build(descriptor: ProjectDescriptor): APIProjectClient =
    new APIProjectClient(descriptor, dependencyFetcher, loader, cache, extensions)

  def build(directory: String): Future[APIProjectClient] = {
    fetchDescriptorFile(directory).map { descriptorAsString =>
      // TODO: don't ignore parse errors
      val descriptor = APBEnv.getProvider(Option(directory)).parse(descriptorAsString.toString()).descriptor
      build(descriptor)
    }
  }

  private def fetchDescriptorFile(directory: String): Future[Content] = {
    val base   = AMFGraphConfiguration.empty()
    val config = loader.fold(base) { resourceLoader => base.withResourceLoader(resourceLoader) }
    platform.fetchContent(directory + "/" + APBEnv.descriptorFileName, config)
  }
}
