package org.mulesoft.apb.client.platform.instances

import amf.aml.internal.convert.VocabulariesClientConverter.ClientFuture
import amf.core.client.scala.validation.AMFValidationReport
import org.mulesoft.apb.client.scala.instances.{
  APIInstanceHandler => InternalAPIInstanceHandler,
  APIInstanceParseResult => InternalAPIInstanceParseResult
}
import org.mulesoft.apb.project.client.platform.model.project.management.APIInstance

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}
import org.mulesoft.apb.internal.convert.APIInstanceHandlerConverter._
import scala.concurrent.ExecutionContext.Implicits.global

@JSExportAll
@JSExportTopLevel("APIInstanceHandler")
object APIInstanceHandler {

  def parse(content: String): ClientFuture[APIInstanceParseResult] = InternalAPIInstanceHandler.parse(content).asClient

  def render(instance: APIInstance): String =
    InternalAPIInstanceHandler.render(APIInstanceConverter.asInternal(instance))
}

@JSExportAll
case class APIInstanceParseResult private[apb] (
    private[apb] val _internal: InternalAPIInstanceParseResult
) {
  def descriptor: APIInstance = _internal.instance

  def report: AMFValidationReport = _internal.report
}
