package org.mulesoft.apb.client.platform

import amf.core.client.platform.resource.ResourceLoader
import org.mulesoft.apb.client.scala.{APIProjectClientBuilder => InternalBuilder}
import org.mulesoft.apb.internal.convert.APBClientConverters.{ClientFuture, _}
import org.mulesoft.apb.project.client.platform.environment.DependencyFetcher
import org.mulesoft.apb.project.client.platform.extensions.APIProjectExtension
import org.mulesoft.apb.project.client.platform.model.descriptor.ProjectDescriptor

import scala.concurrent.ExecutionContext
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
class APIProjectClientBuilder private[apb] (private val internal: InternalBuilder) {

  private implicit val executionContext: ExecutionContext = ExecutionContext.Implicits.global

  @JSExportTopLevel("APIProjectClientBuilder")
  def this(fetcher: DependencyFetcher) {
    this(new InternalBuilder(fetcher)(ExecutionContext.Implicits.global))
  }

  def withResourceLoader(loader: ResourceLoader): APIProjectClientBuilder = {
    internal.withResourceLoader(ResourceLoaderMatcher asInternal loader)
    this
  }

  def withResourceLoaders(loaders: ClientList[ResourceLoader]): APIProjectClientBuilder = {
    internal.withResourceLoaders(loaders.asInternal.toList)
    this
  }

  def withExtensions(extensions: ClientList[APIProjectExtension]): APIProjectClientBuilder = {
    internal.withExtensions(extensions.asInternal)
    this
  }

  def withDirectory(directory: String): APIProjectClientBuilder = {
    internal.withDirectory(directory)
    this
  }

  def withBase(base: String): APIProjectClientBuilder = {
    internal.withBase(base)
    this
  }

  def build(): APIProjectClient = new APIProjectClient(internal.build())

  def build(descriptor: ProjectDescriptor): APIProjectClient = new APIProjectClient(internal.build(descriptor))
}
