package org.mulesoft.apb.internal.gcl

import amf.core.client.common.transform.PipelineId
import amf.core.client.scala.AMFResult
import amf.shapes.client.scala.config.JsonLDSchemaConfiguration
import amf.shapes.client.scala.model.document.JsonSchemaDocument
import org.mulesoft.apb.internal.generated._
import org.mulesoft.apb.project.internal.instances.ResourceKind._

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future
object SchemaProvider {

  def get(kind: String): Option[String] = schemas.get(kind)

  def all = schemas

  lazy val extensionSchema: Future[JsonSchemaDocument] = {
    val configuration = (GCLSchemaDefaultRL.extensionLoaders ++ GCLSchemaDefaultRL.commonLoader).foldLeft(
        JsonLDSchemaConfiguration.JsonLDSchema()
    )((config, rl) => config.withResourceLoader(rl))
    configuration
      .baseUnitClient()
      .parse(Extension.kind)
      .map(transform(_, configuration))
      .map(_.baseUnit.asInstanceOf[JsonSchemaDocument])
  }

  private def transform(parsed: AMFResult, configuration: JsonLDSchemaConfiguration) = {
    val transformed = configuration.baseUnitClient().transform(parsed.baseUnit, PipelineId.Editing)
    transformed.copy(results = parsed.results ++ transformed.results)
  }

  def extensions(): Map[String, String] = Map(
      Extension.kind -> ExtensionSchema.schema
  )

  private val schemas: Map[String, String] = Map(
      ApiInstance.kind        -> ApiInstanceSchema.schema,
      EnvironmentBinding.kind -> EnvironmentBindingSchema.schema,
      Environment.kind        -> EnvironmentSchema.schema,
      Extension.kind          -> ExtensionSchema.schema,
      PolicyBinding.kind      -> PolicyBindingSchema.schema,
      Service.kind            -> ServiceSchema.schema,
      Alert.kind              -> AlertSchema.schema,
      "commons.json"          -> Common.schema
  )
}
