package org.mulesoft.apb.client.platform.model

import amf.apicontract.client.scala.model.domain.api.Api
import amf.core.client.platform.model.document.BaseUnit
import amf.core.client.platform.model.domain.DomainElement
import amf.core.internal.metamodel.Obj
import amf.core.internal.parser.domain.{Annotations, Fields}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.internal.metamodel.ProjectInfoModel
import org.mulesoft.apb.internal.metamodel.ProjectInfoModel.{Contract, Instances}
import org.mulesoft.apb.client.scala.model.{ProjectInfo => InternalProjectInfo}
import org.mulesoft.apb.internal.convert.APBClientConverters._

class ProjectInfo(private[apb] val _internal: InternalProjectInfo) {

  def this() = this(InternalProjectInfo())

  def apiContract(): BaseUnit = _internal.apiContract()
  def instances(): ClientList[JsonLDObject] = {
    new InternalSeqOps(_internal.instances())(new IdentityMatcher[JsonLDObject] {}).asClient
  }

}
