package org.mulesoft.apb.internal.generated

object ApiInstanceSchema {

  def schema: String = """{
                          |  "$schema": "https://json-schema.org/draft-07/schema",
                          |  "@context": {
                          |    "@type": [
                          |      "http://anypoint.com/vocabs/management#APIInstance"
                          |    ]
                          |  },
                          |  "type": "object",
                          |  "properties": {
                          |    "apiVersion": {
                          |      "type": "string"
                          |    },
                          |    "kind": {
                          |      "type": "string",
                          |      "const": "ApiInstance"
                          |    },
                          |    "metadata": {
                          |      "type": "object",
                          |      "properties": {
                          |        "name": {
                          |          "type": "string"
                          |        },
                          |        "labels": {
                          |          "type": "object",
                          |          "properties": {
                          |            "mulesoft.com/apiinstance-id": {
                          |              "type": "integer"
                          |            },
                          |            "mulesoft.com/apiinstance-label:": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/apiinstance-name": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/environment-id": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/organization-id": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/apiinstance-group-id": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/apiinstance-asset-id": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/apiinstance-asset-name": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/apiinstance-version": {
                          |              "type": "string"
                          |            }
                          |          },
                          |          "required": [
                          |            "mulesoft.com/apiinstance-id",
                          |            "mulesoft.com/environment-id",
                          |            "mulesoft.com/organization-id"
                          |          ]
                          |        },
                          |        "annotations": {
                          |          "type": "object",
                          |          "properties": {
                          |            "mulesoft.com/apiinstance-deprecated": {
                          |              "type": "boolean"
                          |            },
                          |            "mulesoft.com/apiinstance-deployment-target": {
                          |              "type": [
                          |                "string",
                          |                "null"
                          |              ],
                          |              "enum": [
                          |                "CH",
                          |                "HY",
                          |                "RTF",
                          |                null
                          |              ]
                          |            },
                          |            "mulesoft.com/apiinstance-deployment-runtime-version": {
                          |              "type": "string"
                          |            },
                          |            "mulesoft.com/apiinstance-deployment-technology": {
                          |              "type": "string",
                          |              "enum": [
                          |                "mule4",
                          |                "mule3",
                          |                "flexGateway",
                          |                "serviceMesh"
                          |              ]
                          |            }
                          |          },
                          |          "required": [
                          |            "mulesoft.com/apiinstance-deployment-technology"
                          |          ]
                          |        }
                          |      },
                          |      "required": [
                          |        "name",
                          |        "labels"
                          |      ]
                          |    },
                          |    "spec": {
                          |      "type": "object",
                          |      "properties": {
                          |        "address": {
                          |          "type": [
                          |            "string",
                          |            "null"
                          |          ]
                          |        },
                          |        "services": {
                          |          "type": "object",
                          |          "patternProperties": {
                          |            "^.*$": {
                          |              "type": "object",
                          |              "properties": {
                          |                "address": {
                          |                  "type": [
                          |                    "string",
                          |                    "null"
                          |                  ]
                          |                },
                          |                "routes": {
                          |                  "type": "array",
                          |                  "items": {
                          |                    "type": "object",
                          |                    "properties": {
                          |                      "rules": {
                          |                        "type": "array",
                          |                        "items": {
                          |                          "type": "object",
                          |                          "properties": {
                          |                            "path": {
                          |                              "type": "string"
                          |                            }
                          |                          },
                          |                          "required": [
                          |                            "path"
                          |                          ]
                          |                        }
                          |                      },
                          |                      "config": {
                          |                        "type": "object",
                          |                        "properties": {
                          |                          "destinationPath": {
                          |                            "type": "string"
                          |                          }
                          |                        }
                          |                      }
                          |                    },
                          |                    "required": [
                          |                      "rules",
                          |                      "config"
                          |                    ]
                          |                  }
                          |                }
                          |              },
                          |              "required": [
                          |                "address",
                          |                "routes"
                          |              ]
                          |            }
                          |          }
                          |        }
                          |      }
                          |    }
                          |  },
                          |  "required": [
                          |    "apiVersion",
                          |    "kind",
                          |    "metadata",
                          |    "spec"
                          |  ]
                          |}""".stripMargin
}
