package org.mulesoft.apb.client.scala

import amf.core.client.scala.validation.AMFValidationReport
import org.mulesoft.apb.project.client.scala.{DependencySet, DependencySetResult}
import org.mulesoft.apb.project.client.scala.descriptor.DescriptorParseResult
import org.mulesoft.apb.project.client.scala.model.ProjectBuildResult
import org.mulesoft.apb.project.client.scala.model.descriptor.Gav
import org.mulesoft.apb.project.client.scala.model.report.{APBReport, APBResult}

import scala.concurrent.Future

trait APIProjectClient {

  def descriptor(): Future[DescriptorParseResult]
  def dependencies(): Future[DependencySetResult]
  def project(): Future[ProjectBuildResult]
  def validate(): Future[APBReport]
  def serialize(): Future[String]
  def summary(schemaBase: String): Future[String]
  def lint(): Future[List[AMFValidationReport]]
  def lint(rulesets: List[Gav]): Future[List[AMFValidationReport]]
}
