package org.mulesoft.apb.internal

import org.mulesoft.apb.project.client.scala.model.project.management.{
  APIInstance,
  Alert,
  PolicyBinding,
  PolicyBindingFilter
}
import org.mulesoft.apb.project.client.scala.model.project.management.SchemaIris._

package object render {

  implicit class APIInstanceResourceOrientedTransformer(apiInstance: APIInstance) {
    def uninline(): APIInstance = {
      removePolicies()
      removeEnvironments()
      removeAlerts()
      apiInstance
    }

    private def removePolicies(): Unit = {
      apiInstance.getObjectIfPresent(SPEC).map { spec =>
        apiInstance.policyBindings.foreach(_.withTargetRef(apiInstance.name))
        spec.removeProperty(POLICIES)
      }
    }

    private def removeEnvironments(): Unit = {
      apiInstance.getObjectIfPresent(SPEC).map { spec =>
        spec.removeProperty(ENVIRONMENT)
      }
    }

    private def removeAlerts(): Unit = {
      apiInstance.getObjectIfPresent(SPEC).map { spec =>
        apiInstance.alerts().foreach { alert =>
          addApiInstanceRef(apiInstance, alert)
        }
        spec.removeProperty(ALERTS)
      }
    }
  }

  private def addApiInstanceRef(apiInstance: APIInstance, alert: Alert) = {
    if (shouldUpdateResources(apiInstance, alert)) {
      alert.updateResource(res => !res.targetsInstance(apiInstance.name)) { res =>
        res.withApiRef(apiInstance.name)
      }
    } else {
      alert.addResource(apiInstance)
    }
  }

  private def shouldUpdateResources(apiInstance: APIInstance, alert: Alert) = {
    !alert.targetsInstance(apiInstance.name) && alert.resources().nonEmpty
  }

  implicit class PolicyBindingResourceOrientedTransformer(policy: PolicyBinding) {

    def uninline(instance: APIInstance): PolicyBinding = {
      removeService()
      removeAlerts(instance)
      policy
    }

    private def removeService(): Unit = {
      policy.specIfPresent.flatMap(_.getObjectIfPresent(CONFIG)).foreach { config =>
        config.getObjectIfPresent(SERVICE).foreach { _ =>
          policy.withPolicyRef("route")
          config.update(DESTINATION_REF) { ref => ref.withProperty(NAME, policy.service.name) }
          config.graph.removeField(SERVICE)
        }
      }
    }

    private def removeAlerts(instance: APIInstance): Unit = {
      policy.specIfPresent.foreach { spec =>
        policy.alerts().foreach(addBindingRefToAlert(policy, instance, _))
        spec.removeProperty(ALERTS)
      }
    }
  }

  private def addBindingRefToAlert(policy: PolicyBinding, instance: APIInstance, alert: Alert) = {
    alert.addFilter(instance, PolicyBindingFilter(policy.name, FILTERS))
  }
}
