package org.mulesoft.apb.internal.render

import amf.shapes.client.scala.config.JsonLDSchemaConfiguration
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.management.{APIInstance, Constants, EnvironmentBinding}
import org.yaml.render.YamlRender

case class APIInstanceRenderer(instance: APIInstance) {

  private val documentSeparator = "\n---\n"
  def render(): String = {
    val docs   = environmentDocuments() ++ serviceDocument() ++ policyBindingDocuments() ++ instanceDocument()
    val client = JsonLDSchemaConfiguration.JsonLDSchema().elementClient()

    docs
      .map { rootObj =>
        val yNode = client.renderElement(rootObj)
        YamlRender.render(yNode)
      }
      .mkString(documentSeparator)
  }

  private def environmentDocuments(): Seq[JsonLDObject] = {
    instance.environmentOption match {
      case Some(env) =>
        // Create env binding doc
        val envBindingObj = EnvironmentBinding(instance.name, env.name).internal

        // Create env doc
        val envObj = env.internal

        Seq(envObj, envBindingObj)
      case None => Nil
    }
  }

  // TODO must update when adding policies
  private def policyBindingDocuments(): Seq[JsonLDObject] =
    instance.policyBindings.map(_.copy().removeService().internal)

  private def instanceDocument(): Seq[JsonLDObject] = {
    Seq(
        instance
          .copy() // we do not want to mutate in rendering
          .removePolicies()
          .removeEnvironments()
          .internal
    )
  }

  private def serviceDocument(): Seq[JsonLDObject] = instance.services.map(_.internal)
}
