package org.mulesoft.apb.client.scala

import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.unsafe.PlatformSecrets
import org.mulesoft.apb.internal.client.project.{
  DefaultAPIProjectClient,
  DescriptorFinder,
  FileSystemInMemoryDescriptorFinder,
  InMemoryDescriptorFinder
}
import org.mulesoft.apb.project.client.scala.dependency.{CloneOnceUnitCacheBuilder, UnitCacheBuilder}
import org.mulesoft.apb.project.client.scala.descriptor.DescriptorParseResult
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.extensions.APIProjectExtension
import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.internal.environment.{GavPathDependencyFetcher, ProjectRelativeRL}

import scala.concurrent.ExecutionContext

class APIProjectClientBuilder(private val dependencyFetcher: DependencyFetcher)(implicit ctx: ExecutionContext)
    extends PlatformSecrets {

  private var extensions: Seq[APIProjectExtension]    = List.empty
  private var base: Option[String]                    = None
  protected var resourceLoaders: List[ResourceLoader] = platform.loaders().toList
  private var unitCacheBuilder: UnitCacheBuilder      = CloneOnceUnitCacheBuilder

  def withResourceLoaders(loaders: List[ResourceLoader]): this.type = {
    this.resourceLoaders = loaders
    this
  }

  def withResourceLoader(loader: ResourceLoader): this.type = {
    this.resourceLoaders = loader +: this.resourceLoaders
    this
  }

  def withUnitCacheBuilder(builder: UnitCacheBuilder): this.type = {
    this.unitCacheBuilder = builder
    this
  }

  def withExtensions(extensions: Seq[APIProjectExtension]): APIProjectClientBuilder = {
    this.extensions = extensions
    this
  }

  // TODO: reconsider
  def withBase(base: String): APIProjectClientBuilder = {
    this.base = Some(base)
    this
  }

  def withDirectory(directory: String): APIProjectClientBuilder = {
    withResourceLoader(ProjectRelativeRL(directory)) // this is shady
  }

  def build(): APIProjectClient = {
    client(FileSystemInMemoryDescriptorFinder(this.resourceLoaders))
  }

  def build(descriptor: ProjectDescriptor): APIProjectClient = {
    build(DescriptorParseResult(descriptor, Seq.empty))
  }

  private def build(parsedDescriptor: DescriptorParseResult): APIProjectClient = {
    client(InMemoryDescriptorFinder(parsedDescriptor))
  }

  private def client(descriptorFinder: DescriptorFinder) = {
    new DefaultAPIProjectClient(
        descriptorFinder,
        GavPathDependencyFetcher(dependencyFetcher),
        this.resourceLoaders,
        unitCacheBuilder,
        extensions,
        base
    )
  }
}
