package org.mulesoft.apb.internal.generated

object PolicyBindingSchema {

  def schema: String = """{
                          |  "$schema": "https://json-schema.org/draft-07/schema",
                          |  "$id": "http://gateway.mulesoft.com/v1alpha1/PolicyBinding",
                          |  "@context": {
                          |    "@type": [
                          |      "http://anypoint.com/vocabs/management#PolicyBinding"
                          |    ]
                          |  },
                          |  "type": "object",
                          |  "properties": {
                          |    "apiVersion": {
                          |      "type": "string"
                          |    },
                          |    "kind": {
                          |      "type": "string",
                          |      "const": "PolicyBinding"
                          |    },
                          |    "metadata": {
                          |      "$ref": "commons.json#/definitions/Metadata"
                          |    },
                          |    "spec": {
                          |      "type": "object",
                          |      "properties": {
                          |        "targetRef": {
                          |          "type": "object",
                          |          "properties": {
                          |            "kind": {
                          |              "type": "string"
                          |            },
                          |            "name": {
                          |              "type": "string"
                          |            }
                          |          },
                          |          "required": [
                          |            "name"
                          |          ]
                          |        },
                          |        "policyRef": {
                          |          "type": "object",
                          |          "properties": {
                          |            "namespace": {
                          |              "type": "string"
                          |            },
                          |            "name": {
                          |              "type": "string"
                          |            }
                          |          },
                          |          "required": [
                          |            "name"
                          |          ]
                          |        },
                          |        "config": {
                          |          "type": "object"
                          |        },
                          |        "rules": {
                          |          "type": "array",
                          |          "items": {
                          |            "type": "object",
                          |            "properties": {
                          |              "path": {
                          |                "type": "string"
                          |              },
                          |              "method": {
                          |                "type": "string"
                          |              },
                          |              "host": {
                          |                "type": "string"
                          |              },
                          |              "headers": {
                          |                "type": "object",
                          |                "additionalProperties": {
                          |                  "type": "string"
                          |                }
                          |              }
                          |            }
                          |          }
                          |        },
                          |        "order": {
                          |          "type": "integer"
                          |        }
                          |      },
                          |      "required": [
                          |        "targetRef"
                          |      ]
                          |    }
                          |  },
                          |  "required": [
                          |    "apiVersion",
                          |    "kind",
                          |    "metadata",
                          |    "spec"
                          |  ]
                          |}""".stripMargin
}
