package org.mulesoft.apb.internal.client.project

import amf.core.client.common.validation.ProfileName
import amf.core.client.scala.resource.ResourceLoader
import amf.core.client.scala.AMFGraphConfiguration
import amf.core.client.scala.validation.AMFValidationReport
import amf.core.internal.unsafe.PlatformSecrets
import org.mulesoft.apb.project.client.scala.descriptor.DescriptorParseResult
import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.internal.parser.APBEnv

import scala.concurrent.{ExecutionContext, Future}

trait DescriptorFinder {

  def find(): Future[DescriptorParseResult]
}

case class InMemoryDescriptorFinder(descriptor: DescriptorParseResult) extends DescriptorFinder {
  override def find(): Future[DescriptorParseResult] = Future.successful(descriptor)
}

case class FileSystemInMemoryDescriptorFinder(loaders: List[ResourceLoader])(implicit ec: ExecutionContext)
    extends DescriptorFinder
    with PlatformSecrets {
  override def find(): Future[DescriptorParseResult] = {
    for {
      content <- fetchDescriptorFile()
    } yield {
      parseDescriptor(content.stream.toString)
    }
  }

  private def fetchDescriptorFile() = fetchFile(APBEnv.descriptorFileName)

  private def fetchFile(file: String) = {
    val config = AMFGraphConfiguration.empty().withResourceLoaders(loaders)
    platform.fetchContent(file, config)
  }

  private def parseDescriptor(descriptor: String): DescriptorParseResult = APBEnv.getHandler().parse(descriptor)
}
