package org.mulesoft.apb.internal.generated

import amf.core.internal.remote.Mimes
import org.mulesoft.apb.internal.gcl.SchemaProvider
import org.mulesoft.apb.internal.loaders.InMemoryResourceLoader

object GCLSchemaDefaultRL {

  val loaders: Seq[InMemoryResourceLoader] = SchemaProvider.all.toList.map { case (kind, schema) =>
    InMemoryResourceLoader(kind, schema, Mimes.`application/json`)
  }

  def commonLoader: Option[InMemoryResourceLoader] = SchemaProvider
    .get("commons.json")
    .map(schema => InMemoryResourceLoader("commons.json", schema, Mimes.`application/json`))

  def extensionLoaders: Seq[InMemoryResourceLoader] =
    SchemaProvider.extensions().toList.map { case (kind, schema) =>
      InMemoryResourceLoader(kind, schema, Mimes.`application/json`)
    }
}
