package org.mulesoft.apb.internal.convert

import amf.core.internal.convert.{BidirectionalMatcher, InternalClientMatcher}
import org.mulesoft.apb.client.platform.{APBOptions => ClientAPBOptions, APIProjectClient => ClientAPIProjectClient}
import org.mulesoft.apb.client.scala.{APBOptions, APIProjectClient}
import org.mulesoft.apb.project.client.platform.model.project.{Project => ClientProject}
import org.mulesoft.apb.project.client.scala.model.project.Project
import org.mulesoft.apb.project.internal.convert.APBProjectConverters
object APBClientConverters extends APBProjectConverters {

  implicit object APBProjectConverter extends InternalClientMatcher[Project, ClientProject] {
    override def asClient(from: Project): ClientProject = new ClientProject(from)
  }

  implicit object APBProjectClientConverter extends InternalClientMatcher[APIProjectClient, ClientAPIProjectClient] {
    override def asClient(from: APIProjectClient): ClientAPIProjectClient = new ClientAPIProjectClient(from)
  }

  implicit object APBOptionsMatcher extends BidirectionalMatcher[APBOptions, ClientAPBOptions] {
    override def asClient(from: APBOptions): ClientAPBOptions   = ClientAPBOptions(from)
    override def asInternal(from: ClientAPBOptions): APBOptions = from._internal
  }
}
