package org.mulesoft.apb.internal.client.instances

import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.unsafe.PlatformSecrets
import org.mulesoft.apb.project.client.scala.model.descriptor.Instance
import org.mulesoft.apb.project.internal.instances.ScopedExtensionIndex

import scala.concurrent.ExecutionContext.Implicits.global
class APIInstanceClientBuilder(instance: String) extends PlatformSecrets {

  private var schemaDefinitionUrl: Option[String]   = None
  private var resourceLoaders: List[ResourceLoader] = platform.loaders().toList

  def withSchemaDefinition(url: String): APIInstanceClientBuilder = {
    this.schemaDefinitionUrl = Some(url)
    this
  }

  def withResourceLoader(loader: ResourceLoader): APIInstanceClientBuilder = {
    this.resourceLoaders = loader +: this.resourceLoaders
    this
  }

  def withResourceLoaders(loaders: List[ResourceLoader]): APIInstanceClientBuilder = {
    this.resourceLoaders = loaders
    this
  }

  def build(): APIInstanceClient = APIInstanceClient(Instance(instance), resourceLoaders, ScopedExtensionIndex.Empty)
}
