package org.mulesoft.apb.client.platform

import org.mulesoft.apb.client.scala.{APBOptions => InternalAPBOptions}
import org.mulesoft.apb.internal.convert.APBClientConverters._

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class APBOptions(private[apb] val _internal: InternalAPBOptions) {

  @JSExportTopLevel("APBOptions")
  def this() = this(InternalAPBOptions())

  def isEnforceMainAPIContract: Boolean = _internal.enforceMainAPIContract

  /** Enforces that the root main file of an APIContract must be API like document */
  def withoutEnforceMainAPIContract: APBOptions = _internal.withoutEnforceMainAPIContract


  /** Not enforces that the root main file of an APIContract must be API like document */
  def withEnforceMainAPIContract: APBOptions = _internal.withEnforceMainAPIContract

}
