package org.mulesoft.apb.client.platform

import amf.core.client.platform.validation.AMFValidationReport
import amf.core.internal.convert.CoreClientConverters.{ClientFuture, ClientList, InternalFutureOps, ValidationReportMatcher}
import amf.core.internal.convert.InternalClientMatcher
import org.mulesoft.apb.client.scala.{APIProjectClient => InternalAPIProjectClient}
import org.mulesoft.apb.project.client.platform.DependencySetResult
import org.mulesoft.apb.project.client.platform.descriptor.DescriptorParseResult
import org.mulesoft.apb.project.client.platform.model.ProjectBuildResult
import org.mulesoft.apb.project.client.platform.model.descriptor.Gav
import org.mulesoft.apb.project.client.platform.model.project.Project
import org.mulesoft.apb.project.client.platform.model.report.APBReport
import org.mulesoft.apb.project.client.scala.{DependencySetResult => InternalDependencySetResult}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future
import scala.scalajs.js.annotation.JSExportAll

@JSExportAll
class APIProjectClient private[apb] (private[apb] val _internal: InternalAPIProjectClient) {

  def dependencies(): ClientFuture[DependencySetResult] = asClient(_internal.dependencies())

  def descriptor(): ClientFuture[DescriptorParseResult] = _internal.descriptor().asClient

  def project(): ClientFuture[ProjectBuildResult] = _internal.project().asClient

  def validate(): ClientFuture[APBReport] = _internal.validate().asClient

  def serialize(): ClientFuture[String] = _internal.serialize().asClient

  def serialize(project: Project): String = _internal.serialize(project._internal)

  def summary(schemaBase: String): ClientFuture[String] = _internal.summary(schemaBase).asClient

  def summary(schemaBase: String, format: String): ClientFuture[String] = _internal.summary(schemaBase, format).asClient

  def lint(): ClientFuture[ClientList[AMFValidationReport]] = _internal.lint().asClient

  def lint(rulesets: ClientList[Gav]): ClientFuture[ClientList[AMFValidationReport]] = {
    _internal.lint(rulesets.asInternal.toList).asClient
  }

  private def asClient(internal: Future[InternalDependencySetResult]): ClientFuture[DependencySetResult] = {
    implicit val matcher = new InternalClientMatcher[InternalDependencySetResult, DependencySetResult] {
      override def asClient(from: InternalDependencySetResult): DependencySetResult =
        DependencySetResultConverter.asClient(from)
    }
    internal.asClient
  }
}
