package org.mulesoft.apb.internal.loaders

import amf.core.client.common.remote.Content
import amf.core.client.scala.resource.ResourceLoader

import scala.concurrent.Future

case class InMemoryResourceLoader(acceptsUri: String, content: String, contentType: String) extends ResourceLoader {

  override def fetch(resource: String): Future[Content] = Future.successful {
    new Content(content, resource, contentType)
  }

  override def accepts(resource: String): Boolean = resource == acceptsUri
}
