package org.mulesoft.apb.client.scala.instances

import amf.core.internal.remote.Mimes
import org.mulesoft.apb.internal.client.instances.APIInstanceParseResultAdapter.toAPIInstanceParseResult
import org.mulesoft.apb.internal.loaders.InMemoryResourceLoader
import org.mulesoft.apb.internal.render.APIInstanceRenderer
import org.mulesoft.apb.project.client.scala.model.descriptor.Instance
import org.mulesoft.apb.project.client.scala.model.project.management.APIInstance
import org.mulesoft.apb.project.client.scala.model.report.APBResult

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

object APIInstanceHandler {

  private val DEFAULT_IRI = "http://a.ml/amf/default_document"
  def parse(content: String): Future[APIInstanceParseResult] = {
    APIInstanceClient
      .build(Instance(DEFAULT_IRI), List(InMemoryResourceLoader(DEFAULT_IRI, content, Mimes.`application/yaml`)))
      .map(toAPIInstanceParseResult)
  }

  def render(instance: APIInstance): String = APIInstanceRenderer(instance).render()
}

case class APIInstanceParseResult(instance: APIInstance, result: Seq[APBResult])
