package org.mulesoft.apb.internal.generated

import amf.core.internal.remote.Mimes
import org.mulesoft.apb.internal.gcl.SchemaProvider
import org.mulesoft.apb.internal.gcl.SchemaProvider.{COMMONS_SCHEMA_FILENAME, sanitizeSchemaNames}
import org.mulesoft.apb.internal.loaders.InMemoryResourceLoader

object GCLSchemaDefaultRL {

  val loaders: Seq[InMemoryResourceLoader] = SchemaProvider.all.toList.map { case (kind, schema) =>
    InMemoryResourceLoader(sanitizeSchemaNames(kind), schema, Mimes.`application/json`)
  } ++ commonLoader

  def commonLoader: Option[InMemoryResourceLoader] = SchemaProvider
    .get(COMMONS_SCHEMA_FILENAME)
    .map(schema => InMemoryResourceLoader(COMMONS_SCHEMA_FILENAME, schema, Mimes.`application/json`))

  def extensionLoaders: Seq[InMemoryResourceLoader] =
    SchemaProvider.extensions().toList.map { case (kind, schema) =>
      InMemoryResourceLoader(sanitizeSchemaNames(kind), schema, Mimes.`application/json`)
    }
}
