package org.mulesoft.apb.internal.client

import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.unsafe.PlatformSecrets
import org.mulesoft.apb.project.client.scala.DependencySetResult
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.internal.dependency.DependencySetParser
import org.mulesoft.apb.project.internal.environment.ProjectRelativeRL

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future

abstract class APIBaseClientBuilder[T](val dependencyFetcher: DependencyFetcher) extends PlatformSecrets {

  protected var resourceLoaders: List[ResourceLoader] = platform.loaders().toList

  def withResourceLoaders(loaders: List[ResourceLoader]): this.type = {
    this.resourceLoaders = loaders
    this
  }

  def withResourceLoader(loader: ResourceLoader): this.type = {
    this.resourceLoaders = loader +: this.resourceLoaders
    this
  }

  def build(descriptor: ProjectDescriptor): Future[T] = getProjectConfigurationBuilder.build(descriptor).map(build)

  def build(directory: String): Future[T] = {
    withResourceLoader(ProjectRelativeRL(directory))
    getProjectConfigurationBuilder.buildFromDirectory(directory: String).map(build)
  }

  def buildFromContent(descriptorAsString: String): Future[T] =
    getProjectConfigurationBuilder.buildFromContent(descriptorAsString).map(build)

  protected def build(projectConfiguration: DependencySetResult): T

  protected def getProjectConfigurationBuilder: DependencySetParser

}
