package org.mulesoft.apb.client.platform.instances

import amf.aml.internal.convert.VocabulariesClientConverter.{ClientFuture, ClientList}
import org.mulesoft.apb.client.scala.instances.{
  APIInstanceHandler => InternalAPIInstanceHandler,
  APIInstanceParseResult => InternalAPIInstanceParseResult
}
import org.mulesoft.apb.internal.convert.APIInstanceHandlerConverter._
import org.mulesoft.apb.project.client.platform.model.project.management.APIInstance
import org.mulesoft.apb.project.client.platform.model.report.APBResult
import org.mulesoft.apb.project.internal.convert.APBProjectConverters.APBResultConverter

import scala.concurrent.ExecutionContext.Implicits.global
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
@JSExportTopLevel("APIInstanceHandler")
object APIInstanceHandler {

  def parse(content: String): ClientFuture[APIInstanceParseResult] = InternalAPIInstanceHandler.parse(content).asClient

  def render(instance: APIInstance): String =
    InternalAPIInstanceHandler.render(APIInstanceConverter.asInternal(instance))
}

@JSExportAll
case class APIInstanceParseResult private[apb] (
    private[apb] val _internal: InternalAPIInstanceParseResult
) {
  def descriptor: APIInstance = _internal.instance

  def result: ClientList[APBResult] = _internal.result.asClient
}
