/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.scaffolding.internal;

import org.mule.apikit.scaffolding.api.Scaffolder;
import org.mule.apikit.scaffolding.api.ScaffoldingConfig;
import org.mule.apikit.scaffolding.api.ScaffoldingResult;
import org.mule.apikit.scaffolding.internal.mapper.ApiGraphMapper;
import org.mule.apikit.scaffolding.internal.template.TemplateEngine;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import static java.util.Collections.emptyList;
import static java.util.Collections.emptyMap;

public class APIKitScaffolder implements Scaffolder {

  private ApiGraphMapper graphMapper;
  private TemplateEngine templateEngine;

  public APIKitScaffolder(ApiGraphMapper graphMapper, TemplateEngine templateEngine) {
    this.graphMapper = graphMapper;
    this.templateEngine = templateEngine;
  }

  public ScaffoldingResult scaffold(ScaffoldingConfig scaffoldingConfig) {
    String apiGraph = graphMapper.buildGraph(scaffoldingConfig.getApi());
    try {
      Map<String, InputStream> result = templateEngine.execute(apiGraph, scaffoldingConfig);
      if (!isReScaffolding(scaffoldingConfig.getExistingConfigurations())) {
        String propertiesFileName = "dev-properties.yaml";
        Path propertiesFile = Paths.get("properties", propertiesFileName);
        return new ScaffoldingResultImpl(true, result, emptyList(), new HashMap<String, InputStream>() {

          {
            put(propertiesFileName,
                APIKitScaffolder.class.getClassLoader().getResourceAsStream(propertiesFile.toString()));
          }
        });
      }
      return new ScaffoldingResultImpl(true, result, emptyList());
    } catch (IOException e) {
      return new ScaffoldingResultImpl(false, emptyMap(), Arrays.asList(() -> String.valueOf(e.getCause())));
    }
  }

  private static boolean isReScaffolding(Set<String> existingConfigurations) {
    return existingConfigurations != null && !existingConfigurations.isEmpty();
  }
}
