/**
* This module contains DataWeave functions to help scaffolding application elements
*/
%dw 2.0
ns core http://www.mulesoft.org/schema/mule/core
// Common configuration names referenced by several script files
var listenerConfigName = "http-listener-config"
var routerConfigName = "api-router-config"

// Util function intended to be used in conjunction of scaffoldElement to lookup for the existing element by a conditional function sent as parameter
fun lookupElementFromApp(existingConfiguration, conditionals) = existingConfiguration.core#mule filterObject ((value, key, index) -> conditionals(value,key,index))
// Util function to (re-)scaffold an element
fun scaffoldElement(element, lookupElementFunction) = do {
    var originalElement = lookupElementFunction
    ---
    if (!isEmpty(originalElement)) {
      (originalElement)
    }
    else {
      (element)
    }
}