/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.scaffolding.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mule.apikit.scaffolding.api.Scaffolder;
import org.mule.apikit.scaffolding.api.ScaffoldingConfig;
import org.mule.apikit.scaffolding.api.ScaffoldingResult;
import org.mule.apikit.scaffolding.internal.ScaffoldingResultImpl;
import org.mule.apikit.scaffolding.internal.mapper.ApiGraphMapper;
import org.mule.apikit.scaffolding.internal.template.TemplateEngine;

public class APIKitScaffolder
implements Scaffolder {
    private ApiGraphMapper graphMapper;
    private TemplateEngine templateEngine;

    public APIKitScaffolder(ApiGraphMapper graphMapper, TemplateEngine templateEngine) {
        this.graphMapper = graphMapper;
        this.templateEngine = templateEngine;
    }

    @Override
    public ScaffoldingResult scaffold(ScaffoldingConfig scaffoldingConfig) {
        String apiGraph = this.graphMapper.buildGraph(scaffoldingConfig.getApi());
        try {
            Map<String, InputStream> result = this.templateEngine.execute(apiGraph, scaffoldingConfig);
            if (!APIKitScaffolder.isReScaffolding(scaffoldingConfig.getExistingConfigurations())) {
                final String propertiesFileName = "dev-properties.yaml";
                final Path propertiesFile = Paths.get("properties", propertiesFileName);
                return new ScaffoldingResultImpl(true, result, Collections.emptyList(), (Map<String, InputStream>)new HashMap<String, InputStream>(){
                    {
                        this.put(propertiesFileName, APIKitScaffolder.class.getClassLoader().getResourceAsStream(propertiesFile.toString()));
                    }
                });
            }
            return new ScaffoldingResultImpl(true, result, Collections.emptyList());
        }
        catch (IOException e) {
            return new ScaffoldingResultImpl(false, Collections.emptyMap(), Arrays.asList(() -> String.valueOf(e.getCause())));
        }
    }

    private static boolean isReScaffolding(Set<String> existingConfigurations) {
        return existingConfigurations != null && !existingConfigurations.isEmpty();
    }
}

