/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.scaffolding.internal.template;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.mule.apikit.scaffolding.api.ScaffoldingConfig;
import org.mule.apikit.scaffolding.internal.template.TemplateEngine;
import org.mule.weave.v2.module.MimeType;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;

public class DataWeaveTemplateEngine
implements TemplateEngine {
    private static final String EMPTY_MULE_APP = "<core:mule xmlns:core=\"http://www.mulesoft.org/schema/mule/core\"/>";
    private static final String API_ID = "api";
    private static final String EXISTING_CONFIGURATION_ID = "existingConfiguration";
    private static final String CONFIGURATION_URLS_CSV_ID = "configUrls";
    private DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine();

    @Override
    public Map<String, InputStream> execute(String apiGraph, ScaffoldingConfig scaffoldingConfig) throws IOException {
        HashMap<String, InputStream> results = new HashMap<String, InputStream>();
        ScriptingBindings bindings = this.getBindings(apiGraph, scaffoldingConfig.getExistingConfigurations());
        for (Map.Entry<String, InputStream> template : scaffoldingConfig.getTemplates().entrySet()) {
            DataWeaveScript compiledScript = this.dataWeaveScriptingEngine.compile(IOUtils.toString((InputStream)template.getValue(), (Charset)StandardCharsets.UTF_8), bindings.bindingNames());
            DataWeaveResult result = compiledScript.write(bindings);
            results.put(DataWeaveTemplateEngine.getScaffoldedConfigurationFileName(template.getKey()), (InputStream)result.getContent());
        }
        return results;
    }

    private String mergeExistingConfigurations(Set<String> existingConfigURLs) {
        if (existingConfigURLs == null || existingConfigURLs.isEmpty()) {
            return EMPTY_MULE_APP;
        }
        ScriptingBindings bindings = new ScriptingBindings();
        bindings.addBinding(CONFIGURATION_URLS_CSV_ID, (Object)String.join((CharSequence)"\n", existingConfigURLs), "text/plain");
        Path pathToMergeScript = Paths.get("src", "main", "resources", "scripts", "mergeConfigs.dwl");
        DataWeaveScript compiledScript = this.dataWeaveScriptingEngine.compile(new File(pathToMergeScript.toString()), bindings.bindingNames());
        DataWeaveResult result = compiledScript.write(bindings);
        return result.getContentAsString();
    }

    private ScriptingBindings getBindings(String apiGraph, Set<String> existingConfigURLs) {
        ScriptingBindings scriptingBindings = new ScriptingBindings();
        scriptingBindings.addBinding(API_ID, (Object)apiGraph, MimeType.APPLICATION_JSON().toString());
        scriptingBindings.addBinding(EXISTING_CONFIGURATION_ID, (Object)this.mergeExistingConfigurations(existingConfigURLs), "application/xml");
        return scriptingBindings;
    }

    private static String getScaffoldedConfigurationFileName(String templateFileName) {
        return templateFileName.substring(0, templateFileName.indexOf(".")) + ".xml";
    }
}

