%dw 2.0
input api application/json
input existingConfiguration application/xml
output application/xml
import every,firstWith from dw::core::Arrays
import toBoolean from dw::util::Coercions
import * from scripts::modules::ScaffoldingModule
ns http http://www.mulesoft.org/schema/mule/http
var graphqlRouter = {uri: "http://www.mulesoft.org/schema/mule/graphql-router", prefix: "graphql-router"} as Namespace
---
mule @("xmlns": "http://www.mulesoft.org/schema/mule/core",
    "xmlns:http": "http://www.mulesoft.org/schema/mule/http",
    "xmlns:graphql-router": "http://www.mulesoft.org/schema/mule/graphql-router",
    "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance",
    "xsi:schemaLocation":
    "http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd http://www.mulesoft.org/schema/mule/http http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd http://www.mulesoft.org/schema/mule/graphql-router http://www.mulesoft.org/schema/mule/graphql-router/current/mule-graphql-router.xsd"): {
    (
        scaffoldElement(
            (http#"listener-config" @("name": listenerConfigName): {
                 http#"listener-connection" @("host": "\${http.listener.host}", "port": "\${http.listener.port}"): {}
             }),
            lookupElementFromApp(
                existingConfiguration,
                (value, key, index) -> key ~= "listener-config" and value.@name == listenerConfigName
            )
         )
    ),
    (
        scaffoldElement(
            (graphqlRouter#config @("name": routerConfigName, "api": "\${api.path}"): {}),
            lookupElementFromApp(
                existingConfiguration,
                (value, key, index) -> key ~= "config" and value.@name == routerConfigName
            )
        )
    ),
    (
        scaffoldElement(
        ("configuration-properties" @("file": "\${env}-properties.yaml"): {}),
            lookupElementFromApp(
                existingConfiguration,
                (value, key, index) -> key ~= "configuration-properties" and value.@file == "\${env}-properties.yaml"
            )
        )
    ),
    (
        scaffoldElement(
        ("global-property" @("name": "env", "value": "dev"): {}),
            lookupElementFromApp(
                existingConfiguration,
                (value, key, index) -> key ~= "global-property" and value.@name == "env" and value.@value == "dev"
            )
        )
    )
}