/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.scaffolding.api;

import java.io.InputStream;
import java.util.Map;
import java.util.Set;

public interface ScaffoldingConfig {

  /**
   * @return Root api content URL
   */
  String getApi();

  /**
   * @return Existing configuration URLs
   */
  Set<String> getExistingConfigurations();

  /**
   * @return Selected templates contents discriminated by name
   */
  Map<String, InputStream> getTemplates();

}
