/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.scaffolding.internal;

import org.mule.apikit.scaffolding.api.Scaffolder;
import org.mule.apikit.scaffolding.api.ScaffoldingConfig;
import org.mule.apikit.scaffolding.api.ScaffoldingResult;
import org.mule.apikit.scaffolding.internal.mapper.ApiGraphMapper;
import org.mule.apikit.scaffolding.internal.template.TemplateEngine;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

import static java.util.Collections.emptyList;
import static java.util.Collections.emptyMap;
import static java.util.Collections.singletonList;


public class APIKitScaffolder implements Scaffolder {

  private final ApiGraphMapper graphMapper;
  private final TemplateEngine templateEngine;

  public APIKitScaffolder(ApiGraphMapper graphMapper, TemplateEngine templateEngine) {
    this.graphMapper = graphMapper;
    this.templateEngine = templateEngine;
  }

  public ScaffoldingResult scaffold(ScaffoldingConfig scaffoldingConfig) {
    String apiGraph = graphMapper.buildGraph(scaffoldingConfig.getApi());
    try {
      Map<String, InputStream> result = templateEngine.execute(apiGraph, scaffoldingConfig);
      Map<String, InputStream> properties = templateEngine.generateProperties(scaffoldingConfig.getApi());
      return new ScaffoldingResultImpl(true, result, emptyList(), properties);
    } catch (IOException e) {
      return new ScaffoldingResultImpl(false, emptyMap(), singletonList(e::toString));
    }
  }

}
