/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.scaffolding.internal;

import org.mule.apikit.scaffolding.api.ScaffoldingError;
import org.mule.apikit.scaffolding.api.ScaffoldingResult;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScaffoldingResultImpl implements ScaffoldingResult {

  private final boolean success;

  private final Map<String, InputStream> xmls;

  private final Map<String, InputStream> propertiesFiles;

  private final List<ScaffoldingError> errors;

  public ScaffoldingResultImpl(boolean success, Map<String, InputStream> xmls, List<ScaffoldingError> errors) {
    this(success, xmls, errors, new HashMap<>());
  }

  public ScaffoldingResultImpl(boolean success, Map<String, InputStream> xmls, List<ScaffoldingError> errors,
                               Map<String, InputStream> propertiesFiles) {
    this.success = success;
    this.xmls = xmls;
    this.errors = errors;
    this.propertiesFiles = propertiesFiles;
  }

  @Override
  public boolean success() {
    return success;
  }

  @Override
  public Map<String, InputStream> generatedMuleXmls() {
    return xmls;
  }

  @Override
  public Map<String, InputStream> generatedPropertiesFiles() {
    return propertiesFiles;
  }

  @Override
  public List<ScaffoldingError> errors() {
    return errors;
  }
}
