/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.scaffolding.internal.config;

import org.mule.apikit.scaffolding.api.ScaffoldingConfig;

import java.io.InputStream;
import java.util.Map;
import java.util.Set;

public class ScaffoldingConfigImpl implements ScaffoldingConfig {

  private final String api;
  private final Set<String> existingConfigurations;
  private final Map<String, InputStream> templates;

  public ScaffoldingConfigImpl(String api, Set<String> existingConfigurations,
                               Map<String, InputStream> templates) {
    this.api = api;
    this.existingConfigurations = existingConfigurations;
    this.templates = templates;
  }

  @Override
  public String getApi() {
    return api;
  }

  public Set<String> getExistingConfigurations() {
    return existingConfigurations;
  }

  @Override
  public Map<String, InputStream> getTemplates() {
    return templates;
  }
}
