%dw 2.0
input api application/json
input existingConfiguration application/xml
output application/xml
import * from scripts::modules::ApiGraphModule
import * from scripts::modules::ScaffoldingModule
import every,firstWith from dw::core::Arrays
import toBoolean from dw::util::Coercions
ns http http://www.mulesoft.org/schema/mule/http
var graphqlRouter = {uri: "http://www.mulesoft.org/schema/mule/graphql-router", prefix: "graphql-router"} as Namespace

fun dataFetcherFlow(operationName, objectTypeName, fieldName) = flow @("name": operationName) : {
   graphqlRouter#"data-fetcher" @("config-ref": routerConfigName, "objectTypeName": objectTypeName, "fieldName": fieldName): {},
   graphqlRouter#serialize @("config-ref": routerConfigName, "objectTypeName": objectTypeName, "fieldName": fieldName): {}
}
fun dataFetcherLookupFunction(objectTypeName, fieldName) = lookupElementFromApp(
    existingConfiguration,
    (value, key, index) -> key ~= "flow" and
        value.graphqlRouter#"data-fetcher".@objectTypeName == objectTypeName and
        value.graphqlRouter#"data-fetcher".@fieldName == fieldName
)
---
mule @("xmlns": "http://www.mulesoft.org/schema/mule/core",
    "xmlns:http": "http://www.mulesoft.org/schema/mule/http",
    "xmlns:graphql-router": "http://www.mulesoft.org/schema/mule/graphql-router",
    "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance",
    "xsi:schemaLocation":
    "http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd http://www.mulesoft.org/schema/mule/http http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd http://www.mulesoft.org/schema/mule/graphql-router http://www.mulesoft.org/schema/mule/graphql-router/current/mule-graphql-router.xsd"): {
    (
        scaffoldElement(
            (flow @("name": "api-main-flow"): {
                 http#listener @("config-ref": listenerConfigName, path: "\${http.listener.path}"): {},
                 graphqlRouter#route @("config-ref": routerConfigName): {}
            }),
            lookupElementFromApp(
                existingConfiguration,
                (value, key, index) -> key ~= "flow" and value.@name == "api-main-flow"
            )
        )
    ),
    (
        getOperationsNames(api) map ((operationName) ->
            do {
                var splitOperationName = operationName splitBy  "."
                var objectTypeName = splitOperationName[0] default ""
                var fieldName = splitOperationName[1] default ""
                ---
                scaffoldElement(
                    dataFetcherFlow(operationName,objectTypeName, fieldName),
                    dataFetcherLookupFunction(objectTypeName,fieldName)
                )
            }
        )
    ),
    (
        getNodeShapeTypes(api) flatMap ((schema, index) ->
            getPropertiesFromSchema(api,schema)
                flatMap ((property, index) ->
                    getNotScalarPropertyTypes(api,property)
                        flatMap ((compoundShape, index) ->
                            getNodeShapeFromCompoundShape(api,compoundShape)
                        )
                filter ((item, index) -> !isEmpty(item))
                flatMap ((nodeShape, index) ->
                    do {
                        var objectTypeName = schema."shacl:name"
                        var fieldName = property."shacl:name"
                        var operationName = joinBy([objectTypeName,fieldName],".")
                        ---
                        scaffoldElement(
                            dataFetcherFlow(operationName,objectTypeName, fieldName),
                            dataFetcherLookupFunction(objectTypeName,fieldName)
                        )
                    }
                )
            )
        )
    ),
}
