/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.scaffolding.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.mule.apikit.scaffolding.api.Scaffolder;
import org.mule.apikit.scaffolding.api.ScaffoldingConfig;
import org.mule.apikit.scaffolding.api.ScaffoldingResult;
import org.mule.apikit.scaffolding.internal.ScaffoldingResultImpl;
import org.mule.apikit.scaffolding.internal.mapper.ApiGraphMapper;
import org.mule.apikit.scaffolding.internal.template.TemplateEngine;

public class APIKitScaffolder
implements Scaffolder {
    private final ApiGraphMapper graphMapper;
    private final TemplateEngine templateEngine;

    public APIKitScaffolder(ApiGraphMapper graphMapper, TemplateEngine templateEngine) {
        this.graphMapper = graphMapper;
        this.templateEngine = templateEngine;
    }

    @Override
    public ScaffoldingResult scaffold(ScaffoldingConfig scaffoldingConfig) {
        String apiGraph = this.graphMapper.buildGraph(scaffoldingConfig.getApi());
        try {
            Map<String, InputStream> result = this.templateEngine.execute(apiGraph, scaffoldingConfig);
            Map<String, InputStream> properties = this.templateEngine.generateProperties(scaffoldingConfig.getApi());
            return new ScaffoldingResultImpl(true, result, Collections.emptyList(), properties);
        }
        catch (IOException e) {
            return new ScaffoldingResultImpl(false, Collections.emptyMap(), Collections.singletonList(e::toString));
        }
    }
}

