/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.scaffolding.internal.template;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.mule.apikit.scaffolding.api.ScaffoldingConfig;
import org.mule.apikit.scaffolding.internal.template.TemplateEngine;
import org.mule.weave.v2.module.MimeType;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;

public class DataWeaveTemplateEngine
implements TemplateEngine {
    private static final String EMPTY_MULE_APP = "<core:mule xmlns:core=\"http://www.mulesoft.org/schema/mule/core\"/>";
    private static final String API_ID = "api";
    private static final String EXISTING_CONFIGURATION_ID = "existingConfiguration";
    private static final String CONFIGURATIONS_CONTENT_ID = "configsContent";
    private static final String API_PATH = "apiPath";
    private final DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine();

    @Override
    public Map<String, InputStream> execute(String apiGraph, ScaffoldingConfig scaffoldingConfig) throws IOException {
        Map<String, InputStream> results = this.computeDifferenceUsingTemplateFiles(apiGraph, scaffoldingConfig);
        Map<String, InputStream> mergedResults = this.addDifferenceToExistingFiles(scaffoldingConfig, results);
        return mergedResults;
    }

    private Map<String, InputStream> computeDifferenceUsingTemplateFiles(String apiGraph, ScaffoldingConfig scaffoldingConfig) throws IOException {
        HashMap<String, InputStream> results = new HashMap<String, InputStream>();
        ScriptingBindings bindings = this.getBindings(apiGraph, scaffoldingConfig.getExistingConfigurations());
        for (Map.Entry<String, InputStream> template : scaffoldingConfig.getTemplates().entrySet()) {
            DataWeaveScript compiledScript = this.dataWeaveScriptingEngine.compile(IOUtils.toString((InputStream)template.getValue(), (Charset)StandardCharsets.UTF_8), bindings.bindingNames());
            DataWeaveResult result = compiledScript.write(bindings);
            results.put(DataWeaveTemplateEngine.getScaffoldedConfigurationFileName(template.getKey()), (InputStream)result.getContent());
        }
        return results;
    }

    private Map<String, InputStream> addDifferenceToExistingFiles(ScaffoldingConfig scaffoldingConfig, Map<String, InputStream> results) {
        HashMap<String, InputStream> mergedResults = new HashMap<String, InputStream>();
        results.forEach((k, v) -> mergedResults.put((String)k, this.mergeOutput((String)k, (InputStream)v, scaffoldingConfig.getExistingConfigurations())));
        return mergedResults;
    }

    @Override
    public Map<String, InputStream> generateProperties(String apiPath) {
        HashMap<String, InputStream> results = new HashMap<String, InputStream>();
        ScriptingBindings bindings = new ScriptingBindings();
        bindings.addBinding(API_PATH, (Object)apiPath, "text/plain");
        DataWeaveResult result = this.executeDWScript(DataWeaveTemplateEngine.class.getClassLoader().getResource("scripts/graphql/dev-properties.dwl"), bindings);
        results.put("dev-properties.properties", (InputStream)result.getContent());
        return results;
    }

    private String unionExistingConfigurations(List<String> existingConfigURLs) {
        if (existingConfigURLs == null || existingConfigURLs.isEmpty()) {
            return EMPTY_MULE_APP;
        }
        ScriptingBindings bindings = new ScriptingBindings();
        bindings.addBinding(CONFIGURATIONS_CONTENT_ID, existingConfigURLs, "application/java");
        URL mergeScriptURL = DataWeaveTemplateEngine.class.getClassLoader().getResource("scripts/mergeConfigs.dwl");
        DataWeaveResult result = this.executeDWScript(mergeScriptURL, bindings);
        return result.getContentAsString();
    }

    private DataWeaveResult executeDWScript(URL scriptURL, ScriptingBindings bindings) {
        DataWeaveScript compiledScript = this.dataWeaveScriptingEngine.compile(scriptURL, bindings.bindingNames());
        return compiledScript.write(bindings);
    }

    private ScriptingBindings getBindings(String apiGraph, Set<String> existingConfigURLs) {
        ScriptingBindings scriptingBindings = new ScriptingBindings();
        scriptingBindings.addBinding(API_ID, (Object)apiGraph, MimeType.APPLICATION_JSON().toString());
        ArrayList<String> muleXmls = new ArrayList<String>();
        existingConfigURLs.forEach(xml -> {
            try {
                muleXmls.add(IOUtils.toString((InputStream)new FileInputStream(new File(new URI((String)xml))), (Charset)StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                throw new RuntimeException("Error trying to read existing file", e);
            }
        });
        scriptingBindings.addBinding(EXISTING_CONFIGURATION_ID, (Object)this.unionExistingConfigurations(muleXmls), "application/xml");
        return scriptingBindings;
    }

    private static String getScaffoldedConfigurationFileName(String templateFileName) {
        return templateFileName.substring(0, templateFileName.indexOf(".")) + ".xml";
    }

    private InputStream mergeOutput(String fileName, InputStream content, Set<String> existingConfigURLs) {
        try {
            Map<String, String> fileNames = this.filesNames(existingConfigURLs);
            if (fileNames.get(fileName) == null) {
                return content;
            }
            ArrayList<String> filesContentToMerge = new ArrayList<String>();
            filesContentToMerge.add(IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8));
            filesContentToMerge.add(IOUtils.toString((InputStream)new FileInputStream(new File(new URI(fileNames.get(fileName)))), (Charset)StandardCharsets.UTF_8));
            return new ByteArrayInputStream(this.unionExistingConfigurations(filesContentToMerge).getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("Error trying to read existing file", e);
        }
    }

    private Map<String, String> filesNames(Set<String> existingConfigURLs) {
        HashMap<String, String> result = new HashMap<String, String>();
        existingConfigURLs.forEach(url -> result.put(new File((String)url).getName(), (String)url));
        return result;
    }
}

